<?php
/**
 * Reset payment status to pending for testing webhook
 */

require_once 'db_config.php';

$registrationNumber = 'XC25-4BTZHJ';
$paymentIntentId = 'pi_3RvmyDEX6BkedxdJ0fKBQOFu';

try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME,
        DB_USER,
        DB_PASS,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    
    echo "<h2>Reset Payment Status for Webhook Testing</h2>\n";
    
    // Check current status
    $stmt = $pdo->prepare("
        SELECT pt.registration_number, pt.transaction_status, pt.updated_at,
               r.payment_status, r.updated_at as reg_updated
        FROM payment_transactions pt
        LEFT JOIN registrations r ON pt.registration_number = r.registration_number
        WHERE pt.registration_number = ?
    ");
    $stmt->execute([$registrationNumber]);
    $currentStatus = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "<p><strong>Current Status:</strong></p>\n";
    echo "<pre>" . json_encode($currentStatus, JSON_PRETTY_PRINT) . "</pre>\n";
    
    if (isset($_GET['reset']) && $_GET['reset'] === 'true') {
        // Reset payment transaction status to pending
        $stmt = $pdo->prepare("
            UPDATE payment_transactions 
            SET transaction_status = 'pending',
                updated_at = NOW()
            WHERE registration_number = ?
        ");
        $result1 = $stmt->execute([$registrationNumber]);
        $rows1 = $stmt->rowCount();
        
        // Reset registration payment status to pending
        $stmt = $pdo->prepare("
            UPDATE registrations 
            SET payment_status = 'pending',
                updated_at = NOW()
            WHERE registration_number = ?
        ");
        $result2 = $stmt->execute([$registrationNumber]);
        $rows2 = $stmt->rowCount();
        
        echo "<p style='color: green;'><strong>✅ Status Reset Complete!</strong></p>\n";
        echo "<p>Payment transactions updated: $rows1 rows</p>\n";
        echo "<p>Registrations updated: $rows2 rows</p>\n";
        
        // Check new status
        $stmt = $pdo->prepare("
            SELECT pt.registration_number, pt.transaction_status, pt.updated_at,
                   r.payment_status, r.updated_at as reg_updated
            FROM payment_transactions pt
            LEFT JOIN registrations r ON pt.registration_number = r.registration_number
            WHERE pt.registration_number = ?
        ");
        $stmt->execute([$registrationNumber]);
        $newStatus = $stmt->fetch(PDO::FETCH_ASSOC);
        
        echo "<p><strong>New Status:</strong></p>\n";
        echo "<pre>" . json_encode($newStatus, JSON_PRETTY_PRINT) . "</pre>\n";
        
        echo "<p><strong>✅ Ready for webhook testing!</strong></p>\n";
        echo "<p>Now you can trigger the Stripe webhook and it should update the status to completed/paid.</p>\n";
        
    } else {
        echo "<p><strong>Click the button below to reset the status to pending:</strong></p>\n";
        echo "<a href='?reset=true' style='background: #dc3545; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>Reset to Pending</a>\n";
        echo "<p><em>This will reset both transaction_status and payment_status to 'pending' so you can test the webhook again.</em></p>\n";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>\n";
}
?>
