<?php
/**
 * Admin Directory Index
 * Redirects to appropriate page based on authentication status
 */

// Start session
session_start();

// Include authentication system
require_once 'auth_rbac.php';

// Create auth instance
$auth = new AdminAuth();

// Check if user is logged in
if ($auth->isLoggedIn()) {
    // User is logged in, redirect to dashboard
    header('Location: dashboard.php');
    exit;
} else {
    // User is not logged in, redirect to login page
    header('Location: login.php');
    exit;
}
?>
