<!-- Admin Navigation CSS -->
<link rel="stylesheet" href="includes/admin_nav.css">
<!-- Font Awesome Icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<!-- Top Bar with Logo and User Info -->
<div class="admin-top-bar">
    <div class="admin-top-nav">
        <?php 
        require_once '../logo_helper.php';
        $logoHtml = getAdminLogoHtml('40px', '40px', 'XChange Admin Logo', 'admin-logo-img');
        ?>
        <div class="admin-logo">
            <span class="admin-logo-text">Xchange Admin</span>
        </div>
        <div class="user-info">
            <a href="../index.html" target="_blank" class="frontend-link" title="Open Frontend">
                View Site
            </a>
            <span class="nav-separator"></span>
            <span class="user-name"><?php echo htmlspecialchars($_SESSION['admin_user']['full_name'] ?? 'System Administrator'); ?></span>
            <span class="user-role-badge"><?php echo strtoupper($_SESSION['admin_user']['role'] ?? 'ADMIN'); ?></span>
            <a href="?logout=1" class="logout-btn">Logout</a>
        </div>
    </div>
</div>

<!-- Main Navigation Bar -->
<div class="admin-nav-bar">
    <div class="admin-nav-container">
        <nav class="main-nav">
            <a href="dashboard.php" class="nav-link <?php echo $currentPage === 'dashboard' ? 'active' : ''; ?>">
                <i class="fas fa-chart-bar"></i> Dashboard
            </a>
            <a href="registrations.php" class="nav-link <?php echo $currentPage === 'registrations' ? 'active' : ''; ?>">
                <i class="fas fa-users"></i> Registrations
            </a>
            <a href="delegates.php" class="nav-link <?php echo $currentPage === 'delegates' ? 'active' : ''; ?>">
                <i class="fas fa-graduation-cap"></i> Delegates
            </a>
            <a href="payments.php" class="nav-link <?php echo $currentPage === 'payments' ? 'active' : ''; ?>">
                <i class="fas fa-credit-card"></i> Payments
            </a>
            <a href="email_logs.php" class="nav-link <?php echo $currentPage === 'email_logs' ? 'active' : ''; ?>">
                <i class="fas fa-envelope"></i> Email Logs
            </a>
            
            <?php if (hasPermission('registrations')): ?>
            <div class="nav-dropdown <?php echo in_array($currentPage, ['product-purchases', 'product-catalog', 'product-inventory', 'product-activity-log']) ? 'active' : ''; ?>">
                <a href="#" class="nav-link dropdown-toggle">
                    <i class="fas fa-box"></i> Products <span class="dropdown-arrow">▼</span>
                </a>
                <div class="dropdown-menu">
                    <a href="product-purchases.php" class="dropdown-item <?php echo $currentPage === 'product-purchases' ? 'active' : ''; ?>">
                        <i class="fas fa-shopping-cart"></i> Purchase Management
                    </a>
                    <a href="product-catalog.php" class="dropdown-item <?php echo $currentPage === 'product-catalog' ? 'active' : ''; ?>">
                        <i class="fas fa-list"></i> Product Catalog
                    </a>
                    <a href="product-inventory.php" class="dropdown-item <?php echo $currentPage === 'product-inventory' ? 'active' : ''; ?>">
                        <i class="fas fa-warehouse"></i> Inventory Management
                    </a>
                    <a href="product-analytics.php" class="dropdown-item <?php echo $currentPage === 'product-analytics' ? 'active' : ''; ?>">
                        <i class="fas fa-chart-line"></i> Product Analytics
                    </a>
                    <a href="product-activity-log.php" class="dropdown-item <?php echo $currentPage === 'product-activity-log' ? 'active' : ''; ?>">
                        <i class="fas fa-history"></i> Activity Log
                    </a>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if (hasPermission('registrations')): ?>
            <div class="nav-dropdown <?php echo in_array($currentPage, ['delegate-page', 'special-access-links']) ? 'active' : ''; ?>">
                <a href="#" class="nav-link dropdown-toggle">
                    <i class="fas fa-file-alt"></i> Pages <span class="dropdown-arrow">▼</span>
                </a>
                <div class="dropdown-menu">
                    <a href="delegate-page.php" class="dropdown-item <?php echo $currentPage === 'delegate-page' ? 'active' : ''; ?>">
                        <i class="fas fa-graduation-cap"></i> Delegate Page
                    </a>
                    <a href="special-access-links.php" class="dropdown-item <?php echo $currentPage === 'special-access-links' ? 'active' : ''; ?>">
                        <i class="fas fa-link"></i> Special Access Links
                    </a>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if (hasPermission('settings', 'view')): ?>
            <div class="nav-dropdown <?php echo in_array($currentPage, ['settings', 'email_templates', 'email_template_editor', 'users', 'exports-page']) ? 'active' : ''; ?>">
                <a href="#" class="nav-link dropdown-toggle">
                    <i class="fas fa-cog"></i> Settings <span class="dropdown-arrow">▼</span>
                </a>
                <div class="dropdown-menu">
                    <a href="settings.php" class="dropdown-item <?php echo $currentPage === 'settings' ? 'active' : ''; ?>">
                        <i class="fas fa-wrench"></i> General Settings
                    </a>
                    <a href="settings.php#email" class="dropdown-item <?php echo $currentPage === 'settings' && isset($_GET['tab']) && $_GET['tab'] === 'email' ? 'active' : ''; ?>">
                        <i class="fas fa-envelope-open"></i> Email Configuration
                    </a>
                    <a href="email_templates.php" class="dropdown-item <?php echo $currentPage === 'email_templates' ? 'active' : ''; ?>">
                        <i class="fas fa-file-text"></i> Email Templates
                    </a>
                    <a href="email_template_editor.php" class="dropdown-item <?php echo $currentPage === 'email_template_editor' ? 'active' : ''; ?>">
                        <i class="fas fa-edit"></i> Template Editor
                    </a>
                    <a href="exports-page.php" class="dropdown-item <?php echo $currentPage === 'exports-page' ? 'active' : ''; ?>">
                        <i class="fas fa-download"></i> Data Exports
                    </a>
                    <a href="webhook-settings.php" class="dropdown-item <?php echo $subPage === 'webhooks' ? 'active' : ''; ?>">
                        <i class="fas fa-link"></i> Webhook Settings
                    </a>
                    <?php if (hasPermission('users', 'view')): ?>
                    <a href="users.php" class="dropdown-item <?php echo $currentPage === 'users' ? 'active' : ''; ?>">
                        <i class="fas fa-user"></i> User Management
                    </a>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
        </nav>
    </div>
</div>

<script>
// Enhanced dropdown functionality
document.addEventListener('DOMContentLoaded', function() {
    const dropdowns = document.querySelectorAll('.nav-dropdown');
    
    dropdowns.forEach(dropdown => {
        const toggle = dropdown.querySelector('.dropdown-toggle');
        
        // Desktop hover handling
        if (window.innerWidth > 768) {
            dropdown.addEventListener('mouseenter', function() {
                dropdown.classList.add('show');
            });
            
            dropdown.addEventListener('mouseleave', function() {
                dropdown.classList.remove('show');
            });
        }
        
        // Mobile and desktop click handling
        toggle.addEventListener('click', function(e) {
            e.preventDefault();
            
            // Close other dropdowns
            dropdowns.forEach(otherDropdown => {
                if (otherDropdown !== dropdown) {
                    otherDropdown.classList.remove('mobile-open', 'show');
                }
            });
            
            // Toggle current dropdown
            if (window.innerWidth <= 768) {
                dropdown.classList.toggle('mobile-open');
            } else {
                dropdown.classList.toggle('show');
            }
        });
        
        // Close dropdown when clicking outside
        document.addEventListener('click', function(e) {
            if (!dropdown.contains(e.target)) {
                dropdown.classList.remove('mobile-open', 'show');
            }
        });
    });
    
    // Handle window resize
    window.addEventListener('resize', function() {
        const dropdowns = document.querySelectorAll('.nav-dropdown');
        dropdowns.forEach(dropdown => {
            dropdown.classList.remove('mobile-open', 'show');
        });
    });
    
    // Sticky Navigation Enhancement
    const navBar = document.querySelector('.admin-nav-bar');
    const body = document.body;
    let navBarOffset = 0;
    
    if (navBar) {
        // Get the initial offset position of the navbar
        navBarOffset = navBar.offsetTop;
        
        window.addEventListener('scroll', function() {
            const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
            
            // Add sticky class and body padding when scrolled past navbar
            if (scrollTop > navBarOffset) {
                navBar.classList.add('sticky');
                body.classList.add('nav-sticky');
            } else {
                navBar.classList.remove('sticky');
                body.classList.remove('nav-sticky');
            }
        });
        
        // Recalculate offset on window resize
        window.addEventListener('resize', function() {
            if (!navBar.classList.contains('sticky')) {
                navBarOffset = navBar.offsetTop;
            }
        });
    }
});
</script>
</style>
