# Logo Usage Guide - XChange 2025 Registration System

## Overview
The system now supports **two distinct logos** for comprehensive branding:

### 🏢 **Company Logo**
- **Purpose**: Official business communications, invoices, admin interface
- **Usage**: Professional documents, payment confirmations, admin notifications
- **Storage**: Database key `companyLogo`
- **Priority**: Primary logo for admin interface (with event logo fallback)

### 🎪 **Event Logo** 
- **Purpose**: Event-specific communications and marketing materials
- **Usage**: Registration emails, event confirmations, promotional content
- **Storage**: Database key `eventLogo`
- **Priority**: Primary logo for customer-facing event communications

## Logo Helper Functions

### Company Logo Functions
```php
getCompanyLogo()                    // Get file path
getCompanyLogoUrl()                 // Get full URL
getCompanyLogoHtml()                // Get HTML img tag
getCompanyLogoForEmail()            // Get email-optimized HTML
hasCompanyLogo()                    // Check if exists
getCompanyLogoDimensions()          // Get image info
```

### Event Logo Functions
```php
getEventLogo()                      // Get file path
getEventLogoUrl()                   // Get full URL
getEventLogoHtml()                  // Get HTML img tag
getEventLogoForEmail()              // Get email-optimized HTML
hasEventLogo()                      // Check if exists
getEventLogoDimensions()            // Get image info
```

### Smart Admin Functions
```php
getAdminLogo()                      // Company logo preferred, event logo fallback
getAdminLogoHtml()                  // Admin navigation logo HTML
```

## Usage Recommendations

### 📧 **Email Communications**
- **Registration Confirmations**: Event logo (customer-facing)
- **Payment Confirmations**: Company logo (official business)
- **Admin Notifications**: Company logo (internal business)
- **Event Updates**: Event logo (event-specific)

### 🖥️ **Admin Interface**
- **Navigation Header**: Company logo (preferred) or event logo (fallback)
- **Invoices/Receipts**: Company logo (official documents)
- **Reports**: Company logo (business documents)

### 📄 **Documents**
- **PDF Invoices**: Company logo (official business documents)
- **Registration Certificates**: Event logo (event-specific)
- **Official Letters**: Company logo (business correspondence)

## File Management

### Upload Locations
- Company logos: `uploads/company_logo_[timestamp].[ext]`
- Event logos: `uploads/event_logo_[timestamp].[ext]`

### Supported Formats
- JPG, JPEG, PNG, GIF, SVG, WebP
- Maximum file size: 5MB
- Automatic old file cleanup on new upload

### Admin Interface
- **Settings → General Settings → Event Branding**
- Separate upload sections for each logo type
- Visual preview with remove options
- Clear labeling and usage descriptions

## Implementation Examples

### Email Template Integration
```php
// For event-specific emails
echo getEventLogoForEmail('200px', '80px', 'Event Logo');

// For business/payment emails  
echo getCompanyLogoForEmail('200px', '80px', 'Company Logo');
```

### Admin Navigation
```php
// Smart logo selection (company preferred, event fallback)
echo getAdminLogoHtml('40px', '40px', 'Admin Logo', 'admin-logo-img');
```

### Invoice/Document Headers
```php
// Official business documents
echo getCompanyLogoHtml('150px', '75px', 'Company Logo', 'invoice-logo');
```

## Best Practices

### Logo Selection Strategy
1. **Company Logo**: Use for all official business communications
2. **Event Logo**: Use for event-specific customer communications
3. **Admin Interface**: Company logo preferred for professional appearance
4. **Fallback Logic**: Always provide graceful fallback when logo missing

### Design Considerations
- **Company Logo**: Should be professional, represent organization
- **Event Logo**: Can be more creative, event-themed, colorful
- **Sizing**: Responsive sizing for different contexts (email, web, print)
- **Format**: SVG preferred for scalability, PNG/JPG for compatibility

### File Organization
- Use descriptive filenames with timestamps
- Automatic cleanup prevents storage bloat
- Database storage of paths for easy management
- Consistent upload directory structure

This dual-logo system provides maximum flexibility for professional branding while maintaining clear separation between organizational and event-specific communications.
